#ifndef CUFFTDX_FFT_36_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_36_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<730, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<205>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %12;
mad.lo.s32 r3, r1, 576, r2;
mov.u32 r4, %tid.x;
add.f64 fd25, %19, %24;
add.f64 fd26, %14, fd25;
add.f64 fd27, %21, %26;
add.f64 fd28, %15, fd27;
mul.f64 fd29, fd25, 0d3FE0000000000000;
sub.f64 fd30, %14, fd29;
sub.f64 fd31, %21, %26;
mul.f64 fd32, fd31, 0dBFEBB67AE8584CAA;
add.f64 fd33, fd32, fd30;
sub.f64 fd34, fd30, fd32;
mul.f64 fd35, fd27, 0d3FE0000000000000;
sub.f64 fd36, %15, fd35;
sub.f64 fd37, %19, %24;
mul.f64 fd38, fd37, 0dBFEBB67AE8584CAA;
sub.f64 fd39, fd36, fd38;
add.f64 fd40, fd38, fd36;
add.f64 fd41, %22, %27;
add.f64 fd42, %16, fd41;
add.f64 fd43, %23, %28;
add.f64 fd44, %18, fd43;
mul.f64 fd45, fd41, 0d3FE0000000000000;
sub.f64 fd46, %16, fd45;
sub.f64 fd47, %23, %28;
mul.f64 fd48, fd47, 0dBFEBB67AE8584CAA;
add.f64 fd49, fd48, fd46;
sub.f64 fd50, fd46, fd48;
mul.f64 fd51, fd43, 0d3FE0000000000000;
sub.f64 fd52, %18, fd51;
sub.f64 fd53, %22, %27;
mul.f64 fd54, fd53, 0dBFEBB67AE8584CAA;
sub.f64 fd55, fd52, fd54;
add.f64 fd56, fd54, fd52;
mul.f64 fd57, fd49, 0d3FE0000000000000;
mul.f64 fd58, fd55, 0d3FEBB67AE8584CAA;
sub.f64 fd59, fd57, fd58;
mul.f64 fd60, fd55, 0d3FE0000000000000;
fma.rn.f64 fd61, fd49, 0d3FEBB67AE8584CAA, fd60;
mul.f64 fd62, fd50, 0dBFE0000000000000;
mul.f64 fd63, fd56, 0d3FEBB67AE8584CAA;
sub.f64 fd64, fd62, fd63;
mul.f64 fd65, fd56, 0dBFE0000000000000;
fma.rn.f64 fd66, fd50, 0d3FEBB67AE8584CAA, fd65;
sub.f64 fd67, fd26, fd42;
sub.f64 fd68, fd28, fd44;
add.f64 fd69, fd33, fd59;
add.f64 fd70, fd39, fd61;
sub.f64 fd71, fd33, fd59;
sub.f64 fd72, fd39, fd61;
add.f64 fd73, fd34, fd64;
add.f64 fd74, fd40, fd66;
sub.f64 fd75, fd34, fd64;
sub.f64 fd76, fd40, fd66;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 6;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 576, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %13;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd77, fd78}, [rd6];
mul.f64 fd81, fd70, fd78;
mul.f64 fd82, fd69, fd78;
mul.f64 fd83, fd77, fd70;
mul.f64 fd84, fd77, fd77;
mul.f64 fd85, fd78, fd78;
sub.f64 fd86, fd84, fd85;
mul.f64 fd87, fd78, fd77;
fma.rn.f64 fd88, fd78, fd77, fd87;
mul.f64 fd89, fd74, fd88;
mul.f64 fd90, fd73, fd88;
mul.f64 fd91, fd86, fd74;
mul.f64 fd92, fd77, fd86;
mul.f64 fd93, fd78, fd88;
sub.f64 fd94, fd92, fd93;
mul.f64 fd95, fd77, fd88;
fma.rn.f64 fd96, fd78, fd86, fd95;
mul.f64 fd97, fd68, fd96;
mul.f64 fd98, fd67, fd96;
mul.f64 fd99, fd94, fd68;
ld.global.v2.f64 {fd100, fd101}, [rd6+96];
mul.f64 fd104, fd72, fd101;
mul.f64 fd105, fd71, fd101;
mul.f64 fd106, fd100, fd72;
mul.f64 fd107, fd77, fd100;
mul.f64 fd108, fd78, fd101;
sub.f64 fd109, fd107, fd108;
mul.f64 fd110, fd77, fd101;
fma.rn.f64 fd111, fd78, fd100, fd110;
mul.f64 fd112, fd76, fd111;
mul.f64 fd113, fd75, fd111;
mul.f64 fd114, fd109, fd76;
barrier.sync 0;
mad.lo.s32 r9, r7, 96, r8;
add.f64 fd115, fd28, fd44;
add.f64 fd116, fd26, fd42;
st.shared.v2.f64 [r9], {fd116, fd115};
fma.rn.f64 fd117, fd77, fd69, fd81;
sub.f64 fd118, fd83, fd82;
st.shared.v2.f64 [r9+16], {fd117, fd118};
fma.rn.f64 fd119, fd86, fd73, fd89;
sub.f64 fd120, fd91, fd90;
st.shared.v2.f64 [r9+32], {fd119, fd120};
fma.rn.f64 fd121, fd94, fd67, fd97;
sub.f64 fd122, fd99, fd98;
st.shared.v2.f64 [r9+48], {fd121, fd122};
fma.rn.f64 fd123, fd100, fd71, fd104;
sub.f64 fd124, fd106, fd105;
st.shared.v2.f64 [r9+64], {fd123, fd124};
fma.rn.f64 fd125, fd109, fd75, fd112;
sub.f64 fd126, fd114, fd113;
st.shared.v2.f64 [r9+80], {fd125, fd126};
barrier.sync 0;
mad.lo.s32 r10, r7, -80, r9;
ld.shared.v2.f64 {fd127, fd128}, [r10];
ld.shared.v2.f64 {fd131, fd132}, [r10+96];
ld.shared.v2.f64 {fd135, fd136}, [r10+192];
ld.shared.v2.f64 {fd139, fd140}, [r10+288];
ld.shared.v2.f64 {fd143, fd144}, [r10+384];
ld.shared.v2.f64 {fd147, fd148}, [r10+480];
add.f64 fd151, fd135, fd143;
add.f64 fd152, fd127, fd151;
add.f64 fd153, fd136, fd144;
add.f64 fd154, fd128, fd153;
mul.f64 fd155, fd151, 0d3FE0000000000000;
sub.f64 fd156, fd127, fd155;
sub.f64 fd157, fd136, fd144;
mul.f64 fd158, fd157, 0dBFEBB67AE8584CAA;
add.f64 fd159, fd158, fd156;
sub.f64 fd160, fd156, fd158;
mul.f64 fd161, fd153, 0d3FE0000000000000;
sub.f64 fd162, fd128, fd161;
sub.f64 fd163, fd135, fd143;
mul.f64 fd164, fd163, 0dBFEBB67AE8584CAA;
sub.f64 fd165, fd162, fd164;
add.f64 fd166, fd164, fd162;
add.f64 fd167, fd139, fd147;
add.f64 fd168, fd131, fd167;
add.f64 fd169, fd140, fd148;
add.f64 fd170, fd132, fd169;
mul.f64 fd171, fd167, 0d3FE0000000000000;
sub.f64 fd172, fd131, fd171;
sub.f64 fd173, fd140, fd148;
mul.f64 fd174, fd173, 0dBFEBB67AE8584CAA;
add.f64 fd175, fd174, fd172;
sub.f64 fd176, fd172, fd174;
mul.f64 fd177, fd169, 0d3FE0000000000000;
sub.f64 fd178, fd132, fd177;
sub.f64 fd179, fd139, fd147;
mul.f64 fd180, fd179, 0dBFEBB67AE8584CAA;
sub.f64 fd181, fd178, fd180;
add.f64 fd182, fd180, fd178;
mul.f64 fd183, fd175, 0d3FE0000000000000;
mul.f64 fd184, fd181, 0d3FEBB67AE8584CAA;
sub.f64 fd185, fd183, fd184;
mul.f64 fd186, fd181, 0d3FE0000000000000;
fma.rn.f64 fd187, fd175, 0d3FEBB67AE8584CAA, fd186;
mul.f64 fd188, fd176, 0dBFE0000000000000;
mul.f64 fd189, fd182, 0d3FEBB67AE8584CAA;
sub.f64 fd190, fd188, fd189;
mul.f64 fd191, fd182, 0dBFE0000000000000;
fma.rn.f64 fd192, fd176, 0d3FEBB67AE8584CAA, fd191;
add.f64 %1, fd154, fd170;
add.f64 %0, fd152, fd168;
add.f64 %3, fd165, fd187;
add.f64 %2, fd159, fd185;
add.f64 %5, fd166, fd192;
add.f64 %4, fd160, fd190;
sub.f64 %7, fd154, fd170;
sub.f64 %6, fd152, fd168;
sub.f64 %9, fd165, fd187;
sub.f64 %8, fd159, fd185;
sub.f64 %11, fd166, fd192;
sub.f64 %10, fd160, fd190;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y): "r"(smem), "l"(lut_dp_6_36), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<731, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<11>;
.reg .f64 fd<193>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %12;
mad.lo.s32 r3, r1, 288, r2;
mov.u32 r4, %tid.x;
add.f64 fd25, %19, %24;
add.f64 fd26, %14, fd25;
add.f64 fd27, %21, %26;
add.f64 fd28, %15, fd27;
mul.f64 fd29, fd25, 0d3FE0000000000000;
sub.f64 fd30, %14, fd29;
sub.f64 fd31, %21, %26;
mul.f64 fd32, fd31, 0dBFEBB67AE8584CAA;
add.f64 fd33, fd32, fd30;
sub.f64 fd34, fd30, fd32;
mul.f64 fd35, fd27, 0d3FE0000000000000;
sub.f64 fd36, %15, fd35;
sub.f64 fd37, %19, %24;
mul.f64 fd38, fd37, 0dBFEBB67AE8584CAA;
sub.f64 fd39, fd36, fd38;
add.f64 fd40, fd38, fd36;
add.f64 fd41, %22, %27;
add.f64 fd42, %16, fd41;
add.f64 fd43, %23, %28;
add.f64 fd44, %18, fd43;
mul.f64 fd45, fd41, 0d3FE0000000000000;
sub.f64 fd46, %16, fd45;
sub.f64 fd47, %23, %28;
mul.f64 fd48, fd47, 0dBFEBB67AE8584CAA;
add.f64 fd49, fd48, fd46;
sub.f64 fd50, fd46, fd48;
mul.f64 fd51, fd43, 0d3FE0000000000000;
sub.f64 fd52, %18, fd51;
sub.f64 fd53, %22, %27;
mul.f64 fd54, fd53, 0dBFEBB67AE8584CAA;
sub.f64 fd55, fd52, fd54;
add.f64 fd56, fd54, fd52;
mul.f64 fd57, fd49, 0d3FE0000000000000;
mul.f64 fd58, fd55, 0d3FEBB67AE8584CAA;
sub.f64 fd59, fd57, fd58;
mul.f64 fd60, fd55, 0d3FE0000000000000;
fma.rn.f64 fd61, fd49, 0d3FEBB67AE8584CAA, fd60;
mul.f64 fd62, fd50, 0dBFE0000000000000;
mul.f64 fd63, fd56, 0d3FEBB67AE8584CAA;
sub.f64 fd64, fd62, fd63;
mul.f64 fd65, fd56, 0dBFE0000000000000;
fma.rn.f64 fd66, fd50, 0d3FEBB67AE8584CAA, fd65;
add.f64 fd67, fd26, fd42;
add.f64 fd68, fd28, fd44;
sub.f64 fd69, fd26, fd42;
sub.f64 fd70, fd28, fd44;
add.f64 fd71, fd33, fd59;
add.f64 fd72, fd39, fd61;
sub.f64 fd73, fd33, fd59;
sub.f64 fd74, fd39, fd61;
add.f64 fd75, fd34, fd64;
add.f64 fd76, fd40, fd66;
sub.f64 fd77, fd34, fd64;
sub.f64 fd78, fd40, fd66;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 6;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %13;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd79, fd80}, [rd6];
mul.f64 fd83, fd72, fd80;
fma.rn.f64 fd84, fd79, fd71, fd83;
mul.f64 fd85, fd71, fd80;
mul.f64 fd86, fd79, fd72;
sub.f64 fd87, fd86, fd85;
mul.f64 fd88, fd79, fd79;
mul.f64 fd89, fd80, fd80;
sub.f64 fd90, fd88, fd89;
mul.f64 fd91, fd80, fd79;
fma.rn.f64 fd92, fd80, fd79, fd91;
mul.f64 fd93, fd76, fd92;
fma.rn.f64 fd94, fd90, fd75, fd93;
mul.f64 fd95, fd75, fd92;
mul.f64 fd96, fd90, fd76;
sub.f64 fd97, fd96, fd95;
mul.f64 fd98, fd79, fd90;
mul.f64 fd99, fd80, fd92;
sub.f64 fd100, fd98, fd99;
mul.f64 fd101, fd79, fd92;
fma.rn.f64 fd102, fd80, fd90, fd101;
mul.f64 fd103, fd70, fd102;
fma.rn.f64 fd104, fd100, fd69, fd103;
mul.f64 fd105, fd69, fd102;
mul.f64 fd106, fd100, fd70;
sub.f64 fd107, fd106, fd105;
ld.global.v2.f64 {fd108, fd109}, [rd6+96];
mul.f64 fd112, fd74, fd109;
fma.rn.f64 fd113, fd108, fd73, fd112;
mul.f64 fd114, fd73, fd109;
mul.f64 fd115, fd108, fd74;
sub.f64 fd116, fd115, fd114;
mul.f64 fd117, fd79, fd108;
mul.f64 fd118, fd80, fd109;
sub.f64 fd119, fd117, fd118;
mul.f64 fd120, fd79, fd109;
fma.rn.f64 fd121, fd80, fd108, fd120;
mul.f64 fd122, fd78, fd121;
fma.rn.f64 fd123, fd119, fd77, fd122;
mul.f64 fd124, fd77, fd121;
mul.f64 fd125, fd119, fd78;
sub.f64 fd126, fd125, fd124;
mad.lo.s32 r8, r5, 288, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 48, r8;
st.shared.v2.f64 [r9], {fd67, fd84};
st.shared.v2.f64 [r9+16], {fd94, fd104};
st.shared.v2.f64 [r9+32], {fd113, fd123};
barrier.sync 0;
mad.lo.s32 r10, r7, -40, r9;
ld.shared.f64 fd127, [r10];
ld.shared.f64 fd128, [r10+48];
ld.shared.f64 fd129, [r10+96];
ld.shared.f64 fd130, [r10+144];
ld.shared.f64 fd131, [r10+192];
ld.shared.f64 fd132, [r10+240];
barrier.sync 0;
st.shared.v2.f64 [r9], {fd68, fd87};
st.shared.v2.f64 [r9+16], {fd97, fd107};
st.shared.v2.f64 [r9+32], {fd116, fd126};
barrier.sync 0;
ld.shared.f64 fd133, [r10];
ld.shared.f64 fd134, [r10+48];
ld.shared.f64 fd135, [r10+96];
ld.shared.f64 fd136, [r10+144];
ld.shared.f64 fd137, [r10+192];
ld.shared.f64 fd138, [r10+240];
add.f64 fd139, fd129, fd131;
add.f64 fd140, fd127, fd139;
add.f64 fd141, fd135, fd137;
add.f64 fd142, fd133, fd141;
mul.f64 fd143, fd139, 0d3FE0000000000000;
sub.f64 fd144, fd127, fd143;
sub.f64 fd145, fd135, fd137;
mul.f64 fd146, fd145, 0dBFEBB67AE8584CAA;
add.f64 fd147, fd146, fd144;
sub.f64 fd148, fd144, fd146;
mul.f64 fd149, fd141, 0d3FE0000000000000;
sub.f64 fd150, fd133, fd149;
sub.f64 fd151, fd129, fd131;
mul.f64 fd152, fd151, 0dBFEBB67AE8584CAA;
sub.f64 fd153, fd150, fd152;
add.f64 fd154, fd152, fd150;
add.f64 fd155, fd130, fd132;
add.f64 fd156, fd128, fd155;
add.f64 fd157, fd136, fd138;
add.f64 fd158, fd134, fd157;
mul.f64 fd159, fd155, 0d3FE0000000000000;
sub.f64 fd160, fd128, fd159;
sub.f64 fd161, fd136, fd138;
mul.f64 fd162, fd161, 0dBFEBB67AE8584CAA;
add.f64 fd163, fd162, fd160;
sub.f64 fd164, fd160, fd162;
mul.f64 fd165, fd157, 0d3FE0000000000000;
sub.f64 fd166, fd134, fd165;
sub.f64 fd167, fd130, fd132;
mul.f64 fd168, fd167, 0dBFEBB67AE8584CAA;
sub.f64 fd169, fd166, fd168;
add.f64 fd170, fd168, fd166;
mul.f64 fd171, fd163, 0d3FE0000000000000;
mul.f64 fd172, fd169, 0d3FEBB67AE8584CAA;
sub.f64 fd173, fd171, fd172;
mul.f64 fd174, fd169, 0d3FE0000000000000;
fma.rn.f64 fd175, fd163, 0d3FEBB67AE8584CAA, fd174;
mul.f64 fd176, fd164, 0dBFE0000000000000;
mul.f64 fd177, fd170, 0d3FEBB67AE8584CAA;
sub.f64 fd178, fd176, fd177;
mul.f64 fd179, fd170, 0dBFE0000000000000;
fma.rn.f64 fd180, fd164, 0d3FEBB67AE8584CAA, fd179;
add.f64 %0, fd140, fd156;
add.f64 %1, fd142, fd158;
add.f64 %3, fd153, fd175;
add.f64 %2, fd147, fd173;
add.f64 %5, fd154, fd180;
add.f64 %4, fd148, fd178;
sub.f64 %6, fd140, fd156;
sub.f64 %7, fd142, fd158;
sub.f64 %9, fd153, fd175;
sub.f64 %8, fd147, fd173;
sub.f64 %11, fd154, fd180;
sub.f64 %10, fd148, fd178;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y): "r"(smem), "l"(lut_dp_6_36), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y));
};


#endif
